---
title: Lecture 3：函数的性质
tags:
  - 数学
  - 函数
  - 函数的性质
categories: 
date: 2024-02-26
---
 ---
## 3.1 函数的四类性质
### 3.1.1 单调性
##### **定义**： #单调性
> <font color="#ccc1d9">描述：</font> $\text{如果对于区间 }I\text{ 上的任意两点 }x_1<x_2\text{ 恒有}$ $\begin{aligned}f(x_1)<&f(x_2)&&\text{单调增加}\\f(x_1)>&f(x_2)&&\text{单调减少}\end{aligned}$


### 3.1.2 奇偶性
##### **定义**： #奇偶性
> <font color="#ccc1d9">描述：</font> $\text{设 }y=f(x)\text{ 的定义域 }D\text{ 关于原点对称}，\forall x\in D$
> 1. $f(-x)=f(x)$ -> 偶函数；
> 2. $f(-x)=-f(x)$ -> 奇函数；

**解释**
+ 常见奇函数：$\sin x,\tan x,\arcsin x,\arctan x,\ln\frac{1-x}{1+x},{\ln(x+\sqrt{1+x^2})},\frac{e^x-1}{e^x+1},$$f(-x)=-f(x)$
+ 常见偶函数：$x^2,|x|,\cos x,f(x)=f(-x)$

**性质**
+ 1. $\text{奇函数的图形关于原点对称,且若 }f(x)\text{ 在 }x=\mathbf{0}$ 处有定义，则 $f(0)=0$；
+ 2. 偶函数的图形关于 y 轴对称；
+ 奇偶判断： 
	+ 常见奇函数：$\sin x,\tan x,\arcsin x,\arctan x,\ln\frac{1-x}{1+x},{\ln(x+\sqrt{1+x^2})},\frac{e^x-1}{e^x+1},$$f(-x)=-f(x)$
	+ 常见偶函数：$x^2,|x|,\cos x,f(x)=f(-x)$
+ 运算规则：
	+ 奇函数 + 奇函数 = **奇函数** 
	+ 偶函数 + 偶函数 = 偶函数 
	+ 奇函数 + 偶函数 = **非奇非偶**
	+ 奇函数 × 奇函数 = **偶函数** 
	+ 偶函数 × 偶函数 = 偶函数 
	+ 奇函数 × 偶函数 = 奇函数 
+ 复合函数：
	+ 内奇同外，内偶则偶
	+ 内函数是奇函数，则复合函数的奇偶性和外函数相同；
	+ 内函数是偶函数，则复合函数是偶函数；
+ 导数关系：
	+ 奇函数的导函数：偶函数；
	+ 偶函数的导函数：奇函数；

**方法**
+ 使用奇函数或者偶函数的定义，判断函数是否为奇函数或偶函数；

### 3.1.3 周期性
##### **定义**： #周期性
> <font color="#ccc1d9">描述：</font>若存在实数 $T>0$, 对于任意 $x$, 恒有 $f(x+T)=f(x)$ ，则称 $y=f(x)$ 为周期函数；使得上式成立的最小正数称为最小正周期，简称为函数 $f(x)$ 的周期；

**解释**
+ 平时所指的周期就是最小正周期；

**常见周期函数**
+ 1.  $\sin x,\cos x\text周期为2\pi；\sin2x,|\sin x|\text周期为\pi$
+ 2. $\text{若}f(x)\textit{以}T\text为周期,则f(a\text{x}+b)\textit{ 以}\frac T{|a|}\text{为周期}.$

### 3.1.4 有界性
##### **定义**： #有界性
> <font color="#ccc1d9">描述：</font>若存在 $\left(M>0\right)$ 使得对任意的 $x\in\left\{X,\right\}$ 恒有 $\left|f(x)\right|\leq M$，则称 $f(x)$ 在 $X$ 上为有界函数；如果对任意的 $M>0$,至少存在一个 $x_0\in\overline{X}$,使得  $|f(x_0)|>M$ ，则 $f(x)$ 为 X 上的无界函数；

**解释**
+ 有界 = 有上界+有下界；
+ 注意：有界是相对的，需要说明范围在哪里；

**常见有界函数**
+ $|\sin x|\leq1;|\cos x|\leq1;|\arcsin x|\leq\frac\pi2;|\arctan x|<\frac\pi2,|\arccos x|\leq\pi;$
+ 注意：$|\arctan x|<\frac\pi2$ 是有界函数，常考；

## 3.2 常考题型
### 题型： #函数四类性质的判定
+ 有界函数
	+ 几个基本初等函数相乘时，看当中是否有某一个基本初等函数是无穷的；
	+ 当出现 $sinx、cosx$ 时，可以考虑将 x 取到 $2n\pi + \pi/x$
+ 周期函数
	+ 几个基本初等函数相乘时，看当中是否有某一个基本初等函数不是周期函数。如果有的话，是否会因为它而整个函数越来越大；如果会的话则不是周期函数；
